//Experiment-10
// windows 8.1 - 64-Bit
//Scilab - 6.0.0

//Aim : Core Loss Calculations in magnetic materials using SCILAB Programming
//Data: CAlculate core loss per kg in a specimen of ally sheet using user defined data

clear;
clc;


// Following data is to be taken from user

Bm=input('Enter value of Maximum flux density in Wb/m^2') // maxium flux density (in the range of 0.5 - 2.5 Wb/m^2)
f=input('Enter value of frequency in Hz') // frequency of flux reversal (genrally 50 Hz)
t=input('Enter thickness of laminated plates in mm') // tickness of laminations (in range of 0.2 - 0.6 mm )
r=input('Enter Resistivity of material in Ohm*m')// resistivity in Ohm*m (in the range of 0.2 - 0.6 micro Ohm*m)
sg=input('Enter specific gravity of material in kg/m^3') // specific gravity (in the range of 7 - 10 kg/m^3)
hl=input('Enter value of hysterisis loss in in J*Hz/m^3') // specific hysterisis loss (in range of  400 - 800 J*Hz/m^3)

// Actual calculations begin

Pe=((%pi^2)*(f^2)*(Bm^2)*((t/1000)^2))/((sg*1000)*(6*r)) // eddy current loss per kg
Ph=hl*f/(sg*1e3)
Pi=Pe+Ph
mprintf('Eddy Current Loss per kg for given material is %f W',Pe)
mprintf('\n')
mprintf('Hysterisis Loss per kg for given material is %f W',Ph)
mprintf('\n')
mprintf('Total Iron Loss per kg for given material is %f W',Pi)
